package it.infocamere.wscu.clientws.util;

import java.util.Locale;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

/**
 * Gestisce la codifica e decodifica di stringhe in byte[] in diversi formati
 * @author yye0464
 *
 */
public class CoderEncoder {

	/**
	 * Codifica BASE64
	 */
	public static String BASE64 = "BASE64";
	/**
	 * Codifica Esadecimale
	 */
	public static String HEX = "HEX";
	/**
	 * Codifica Decimale (rappresentazione decimale del carattere seguita da uno spazio)
	 */
	public static String DECIMAL = "DECIMAL";

	private static final String SEPARATORE_VALORI_CODIFICA_SHA1_DECIMALE = " ";
	
	private static CoderEncoder single;
	
	private Base64 base64;
	private Hex hex;

	/**
	 * Ritorna l'istanza (Singleton) della classe
	 * @return
	 */
	public static CoderEncoder getInstance(){
		if (single == null) single = new CoderEncoder();
		return single;
	}
	
	/**
	 * Costruttore di default
	 */
	private CoderEncoder(){
		base64 = new Base64();
		hex = new Hex();
	}
	
	/**
	 * Esegue la codifica della stringa passata
	 * @param input
	 * @param type
	 * @return
	 * @throws FatalException
	 * @throws InputException
	 */
	public String encode(byte[] input, String type) throws Exception {
		if (input==null || input.length<=0) 
			throw new Exception("eccezione.fnv.firmaNullaONonVal");
		if (BASE64.equals(type))
			return new String(base64.encode(input));
		if (HEX.equals(type))
			return new String(hex.encode(input));
		if (DECIMAL.equals(type)){
			StringBuffer ritorno = new StringBuffer();
			for (int i=0; i<input.length; i++) {
				int b = input[i];
				if (b<0) b += 256;
				ritorno.append(b);
				ritorno.append(SEPARATORE_VALORI_CODIFICA_SHA1_DECIMALE);
			}
			return ritorno.toString();
		}
		throw new Exception("eccezione.Fatal.codificaNonSupportata");
	}
	
	/**
	 * Esegue la decodifica del byte[] passato
	 * @param input
	 * @param type
	 * @return
	 * @throws InputException
	 */
	public byte[] decode(String input, String type) throws Exception {
		if (input==null || input.length()<=0) 
			throw new Exception("eccezione.fnv.firmaNullaONonVal");
		try {
			if (BASE64.equals(type))
				return (byte[])base64.decode(input.getBytes());
			if (HEX.equals(type))
				return (byte[])hex.decode(input.getBytes());
			if (DECIMAL.equals(type)){
				String[] token = input.split(SEPARATORE_VALORI_CODIFICA_SHA1_DECIMALE);
				if (token==null || token.length<=0)
					throw new Exception("eccezione.fnv.firmaNullaONonVal");
				byte[] ritorno = new byte[token.length];
				for (int i=0; i<token.length; i++){
					int b = Integer.parseInt(token[i]);
					if (b>128) b -= 256;
					ritorno[i] = (byte) b;
				}
				return ritorno;
			}
		}
		catch (DecoderException e){
			throw new Exception("eccezione.fnv.erroreDecodificaFirma" + e.getLocalizedMessage(), e);
		}
		throw new Exception("eccezione.Fatal.codificaNonSupportata");
	}
}